<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


class RoleMiddleware
{
  /**
   * Handle an incoming request.
   *
   * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
   */
  public function handle($request, Closure $next, ...$roles)
  {
    $user = Auth::user();
    if (!$user || !in_array($user->role, $roles, true)) {
      return redirect()->route('theme.home');
    }
    return $next($request);
  }
}
