<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EditEventRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   */
  public function authorize(): bool
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
   */
  public function rules(): array
  {
    return [

      "event_name" => "required|string|max:255",
      "event_date" => "required|date",
      "event_time" => "required|date_format:H:i",
      "event_location" => "required|string|max:255",
      "event_image" => "nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048",
      "location_url" => "required|url",

    ];
  }
  public function messages(): array
  {
    return [

      "event_name.required" => "يرجى إدخال اسم المناسبة",
      "event_name.max" => "الاسم يجب أن يحتوي على 255 حرف بحد أقصى",
      "event_date.required" => "يرجى إدخال تاريخ المناسبة",
      "event_time.required" => "يرجى إدخال وقت المناسبة",
      "event_time.date_format" => "يرجى إدخال وقت المناسبة بالتنسيق الصحيح",
      "event_location.required" => "يرجى إدخال مكان المناسبة",
      "event_location.max" => "موقع المناسبة يجب أن يحتوي على 255 حرف بحد أقصى",
      "event_image.required" => "يرجى إدخال صورة المناسبة",
      "event_image.mimes" => "يرجى إدخال صورة المناسبة",
      "event_image.max" => "الحجم المسموح به للصورة 2048 كيلوبايت",
      "location_url.required" => "يرجى إدخال رابط الموقع",
      "location_url.url" => "يرجى إدخال رابط الموقع بشكل صحيح",
    ];
  }
}
