<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class GenerateInvitationsRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   */
  public function authorize(): bool
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
   */
  public function rules(): array
  {
    return [
      'invitation_count' => 'required|numeric|min:1|max:' . Auth::user()->user_invitation_limit,
    ];
  }

  public function messages()
  {
    return [
      'invitation_count.required' => 'الحقل مطلوب.',
      'invitation_count.numeric' => 'الحقل يجب أن يكون رقم.',
      'invitation_count.min' => 'الحقل يجب أن يكون أكبر من 0.',
      'invitation_count.max' => 'الحقل يجب أن يكون أقل من ' . Auth::user()->user_invitation_limit,
    ];
  }
}
