<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules;
use App\Models\User;

class registerUserRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   */
  public function authorize(): bool
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
   */
  public function rules(): array
  {
    return [
      'name' => ['required', 'string', 'max:255'],
      'email' => ['required', 'string', 'lowercase', 'email', 'max:255', 'unique:' . User::class],
      'phone_number' => 'required|string|max:12|min:11|regex:/^[0-9]{11,12}$/|unique:' . User::class,
      'password' => ['required', 'confirmed', Rules\Password::defaults()],
    ];
  }

  public function messages()
  {
    return [
      'name.required' => 'الاسم مطلوب',
      'email.required' => 'البريد الالكتروني مطلوب',
      'phone_number.required' => 'رقم الهاتف مطلوب',
      'password.required' => 'كلمة المرور مطلوبة',

      'name.max' => 'الاسم يجب أن يحتوي على 255 حرفًا أو أقل',
      'email.max' => 'البريد الالكتروني يجب أن يحتوي على 255 حرفًا أو أقل',
      'phone_number.max' => 'رقم الهاتف يجب أن يحتوي على 12 رقمًا أو أقل',
      'phone_number.min' => 'رقم الهاتف يجب أن يحتوي على 11 رقمًا أو أكثر',
      'password.min' => 'كلمة المرور يجب أن تحتوي على 8 حرفًا أو أكثر',
      'password.confirmed' => 'كلمة المرور يجب أن تتطابق',
      'email.unique' => 'البريد الالكتروني مستخدم مسبقاً',
      'phone_number.regex' => 'رقم الهاتف يجب أن يبدأ ب 01 و يحتوي على 11 رقمًا',
      'phone_number.unique' => 'رقم الهاتف مستخدم مسبقاً',
    ];
  }
}
