<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class updateUserRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   */
  public function authorize(): bool
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
   */
  public function rules(): array
  {
    return [
      'name' => 'required|string|max:30|min:3',
      'email' => 'required|email|max:255|unique:users,email,' . $this->route('account')->id,
      'phone_number' => [
        'required',
        'regex:/^[0-9]{11,12}$/',
      ],
      'events_limit' => 'required|numeric|min:0',
      'staff_limit' => 'required|numeric|min:0',
      'user_invitation_limit' => 'required|numeric|min:0',
    ];
  }

  public function messages()
  {
    return [
      'name.required' => 'الاسم مطلوب',
      'email.required' => 'البريد الالكتروني مطلوب',
      'phone_number.required' => 'رقم الهاتف مطلوب',
      'events_limit.required' => 'عدد المناسبات المسموح بها مطلوب',
      'staff_limit.required' => 'عدد المنظمين المسموح به مطلوب',
      'user_invitation_limit.required' => 'عدد الدعوات المسموح به مطلوب',
      'events_limit.numeric' => 'عدد المناسبات المسموح بها يجب أن يكون رقم',
      'events_limit.min' => 'عدد المناسبات المسموح بها يجب أن يكون 0 أو أكبر',
      'staff_limit.min' => 'عدد المنظمين المسموح به يجب أن يكون 0 أو أكبر',
      'user_invitation_limit.min' => 'عدد الدعوات المسموح به يجب أن يكون 0 أو أكبر',
      'phone_number.regex' => 'رقم الهاتف يجب أن يكون بين 11 و 12 رقم',
    ];
  }
}
