<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Verified;

class SendVerifyEmailAfterPasswordReset
{
  public function handle(Verified $event): void
  {
    $user = $event->user;

    if (!$user->hasVerifiedEmail()) {
      $user->sendEmailVerificationNotification();
    }
  }
}
