<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffAssignment extends Model
{
  protected $table = 'staff_assignments';

  protected $fillable = [
    'owner_id',
    'staff_id',
  ];

  public function owner()
  {
    return $this->belongsTo(User::class, 'owner_id');
  }

  public function staff()
  {
    return $this->belongsTo(User::class, 'staff_id');
  }
}
