<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class AccountActivatedNotification extends Notification
{
  /**
   * قنوات الإرسال
   */
  public function via($notifiable): array
  {
    return ['mail'];
  }

  /**
   * محتوى الإيميل
   */
  public function toMail($notifiable): MailMessage
  {
    return (new MailMessage)
      ->subject('تم تفعيل حسابك بنجاح 🎉')
      ->greeting('مرحبًا ' . $notifiable->name . ' 👋')
      ->line('نود إبلاغك بأنه تم تعيين كلمة المرور بنجاح.')
      ->line('كما تم تأكيد بريدك الإلكتروني بنجاح.')
      ->line('يمكنك الآن تسجيل الدخول والاستفادة من جميع خدمات منصة Inviteer.')
      ->action('تسجيل الدخول', route('login'))
      ->line('سعداء بانضمامك إلينا 🌟');
  }
}
