  let editorInstance;

  // تهيئة المحرر أول مرة بالعربية
  function initEditor(lang = 'ar', direction = 'rtl') {
    if (editorInstance) {
      editorInstance.destroy(); // تدمير المحرر الحالي إذا موجود
    }
    editorInstance = CKEDITOR.replace("editor1", {
      language: lang,
      contentsLangDirection: direction,
      on: {
        contentDom: function (evt) {
          evt.editor.editable().on("contextmenu", function (contextEvent) {
            var path = evt.editor.elementPath();
            if (!path.contains("table")) {
              contextEvent.cancel();
            }
          }, null, null, 5);
        }
      }
    });
  }

    // بدء المحرر بالعربية
  initEditor();
  
  // مراقبة زر التبديل
  document.getElementById("toggleLangBtn").addEventListener("change", function () {
    if (this.checked) {
      // إنجليزي
      initEditor('en', 'ltr');
    } else {
      // عربي
      initEditor('ar', 'rtl');
    }
  });