@extends('theme.partial.master')
@section('page-title', 'تحقق من البريد الالكتروني')
@section('content')

<x-guest-layout>
  <div class="mb-4 text-sm text-dark dark:text-gray-400" dir="rtl">
    {{ __('شكرًا لتسجيلك! قبل البدء، هل يمكنك التحقق من عنوان بريدك الإلكتروني من خلال النقر على الرابط الذي أرسلناه إليك للتو؟ إذا لم يصلك البريد الإلكتروني، يسعدنا إرسال رابط آخر لك.') }}
  </div>

  @if (session('status') == 'verification-link-sent')
  <div class="mb-4 font-medium text-sm text-green-600 dark:text-green-900">
    {{ __('تم إرسال رابط تحقق جديد إلى عنوان البريد الإلكتروني الذي قدمته أثناء التسجيل.') }}
  </div>
  @endif

  <div class="mt-4 flex items-center justify-between">
    <form method="POST" action="{{ route('verification.send') }}">
      @csrf

      <div>
        <x-primary-button>
          {{ __('إعادة إرسال رابط التحقق') }}
        </x-primary-button>
      </div>
    </form>

    <form method="POST" action="{{ route('logout') }}">
      @csrf

      <button type="submit" class="underline text-sm text-dark dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800">
        {{ __('تسجيل الخروج') }}
      </button>
    </form>
  </div>
</x-guest-layout>

@endsection