@extends('theme.partial.master')
@section('page-title', 'إدارة الحسابات')
@section('content')

<!-- Start Summary Section -->
<x-summary-card :stats="$stats" :title="'ملخص المستخدمين'" />
<!-- End Summary Section -->

@if(session()->has('userSuccess'))
<script>
  Swal.fire({
    icon: 'success',
    title: 'تم بنجاح',
    text: "{{ session('userSuccess') }}",
    confirmButtonText: 'حسناً'
  });
</script>
@endif

@if(session()->has('userError'))
<script>
  Swal.fire({
    icon: 'error',
    title: 'خطأ',
    text: "{{ session('userError') }}",
    confirmButtonText: 'إغلاق'
  });
</script>
@endif

<!-- Owners -->
<div class="col-xl-12 proorder-xl-3 box-col-6 mt-4">
  <div class="card">
    <div class="card-header pb-0">
      <div class="header-top">
        <h1>
          أصحاب الدعوات
        </h1>
      </div>
    </div>
    <div class="card-body">
      <div class="table-responsive custom-scrollbar">
        <table class="last-orders-table table" id="last-orders">
          <thead>
            <tr>
              <th>اسم المستخدم</th>
              <th>البريد الالكتروني</th>
              <th>المناسبات المتاحة</th>
              <th>المناسبات المستخدمة</th>
              <th>المنظمين المتاحين</th>
              <th>المنظمين المضافين</th>
              <th>حالة الحساب</th>
              <th>الإجراءات</th>
            </tr>
          </thead>
          <tbody>
            @if ($eventOwners->isEmpty())
            <tr>
              <div class="justify-content-center d-flex flex-column align-items-center">
                <h2 class="mt-3">لا يوجد مستخدمين</h2>
                <script src="https://unpkg.com/@lottiefiles/dotlottie-wc@0.8.11/dist/dotlottie-wc.js" type="module"></script>
                <dotlottie-wc src="https://lottie.host/8b943b7c-9c0b-41ba-95bf-bd682f15d529/VkbOmAd2rv.lottie" style="width: 300px;height: 300px" autoplay loop></dotlottie-wc>
              </div>
            </tr>
            @else
            @foreach ($eventOwners as $eventOwner)
            <tr>
              <td>
                <a href="{{ route('accounts.show', $eventOwner->id) }}">{{ $eventOwner->name }}</a>
              </td>
              <td>{{ $eventOwner->email }}</td>
              <td>
                <span class="badge {{ $eventOwner->events_limit - $eventOwner->events()->count() > 0 ? 'badge-success' : 'badge-danger' }}">
                  {{ $eventOwner->events_limit - $eventOwner->events()->count() }}
                </span>
              </td>
              <td>
                <span class="badge badge-success">
                  {{ $eventOwner->events()->count() }}
                </span>
              </td>
              <td>
                <span class="badge {{ $eventOwner->staff_limit - $eventOwner->assignedStaff()->count() > 0 ? 'badge-success' : 'badge-danger' }}">
                  {{ $eventOwner->staff_limit - $eventOwner->assignedStaff()->count() }}
                </span>
              </td>
              <td>
                <span class="badge badge-success">
                  {{ $eventOwner->assignedStaff()->count() }}
                </span>
              </td>
              <td>
                <span class="badge {{ $eventOwner->email_verified_at ? 'badge-success' : 'badge-danger' }}">
                  {{ $eventOwner->email_verified_at ? 'مفعل' : 'غير مفعل' }}
                </span>
              </td>

              <td>
                <ul class="action" style="display: flex; gap: 10px;">
                  <li class="primary"><a href="#"><i class="icon-eye"></i></a></li>
                  <li class="edit"><a href="{{ route('accounts.edit', $eventOwner->id) }}"><i class="icon-pencil-alt"></i></a></li>
                  <li class="edit">
                    <a href="{{ route('accounts.show', $eventOwner->id) }}">
                      <i class="fa fa-qrcode"></i>
                      المناسبات
                    </a>
                  </li>
                  <li class="delete">
                    <form action="{{ route('accounts.destroy', $eventOwner->id) }}"
                      method="POST"
                      class="delete-form d-inline">
                      @csrf
                      @method('DELETE')

                      <button type="button" class="btn btn-link p-0 text-danger delete-btn">
                        <i class="icon-trash"></i>
                      </button>
                    </form>
                  </li>
                  <script>
                    document.addEventListener('DOMContentLoaded', function() {

                      document.querySelectorAll('.delete-btn').forEach(button => {
                        button.addEventListener('click', function(e) {

                          const form = this.closest('form');

                          Swal.fire({
                            title: 'هل أنت متأكد؟',
                            text: 'لن يمكنك التراجع بعد الحذف!',
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#6c757d',
                            confirmButtonText: 'نعم، احذف',
                            cancelButtonText: 'إلغاء',
                          }).then((result) => {
                            if (result.isConfirmed) {
                              form.submit();
                            }
                          });

                        });
                      });

                    });
                  </script>

                </ul>
              </td>
            </tr>
            @endforeach
            @endif
          </tbody>
        </table>
        @if ($eventOwners->hasPages())
        <div class="mt-4 me-4">
          {{ $eventOwners->links('pagination::bootstrap-5') }}
        </div>
        @endif

        <div class="mt-4 me-4">
          <a href="{{ route('accounts.create') }}" class="btn btn-primary">أضف مستخدم جديد</a>
        </div>
      </div>
    </div>
  </div>
</div>



@endsection