  @extends('theme.partial.master')
  @section('page-title', $account->name)
  @section('content')

  <!-- Start Create Event Section -->
  <h3>تعديل مستخدم</h3>
  <div class="col-xl-12 mt-4">
    @if(session()->has('userSuccess'))
    <script>
      Swal.fire({
        icon: 'success',
        title: 'تم بنجاح',
        text: "{{ session('userSuccess') }}",
        confirmButtonText: 'حسناً'
      });
    </script>
    @endif

    @if(session()->has('userError'))
    <script>
      Swal.fire({
        icon: 'error',
        title: 'خطأ',
        text: "{{ session('userError') }}",
        confirmButtonText: 'إغلاق'
      });
    </script>
    @endif

    <div class="card height-equal">
      <div class="card-header pb-0">
        <h4> تعديل بيانات {{ $account->name }}</h4>
        <p class="f-m-light mt-1">يرجى تعبئة كافة الحقول بشكل صحيح قبل الإرسال.</p>
      </div>
      <div class="card-body">
        <form class="row g-3 needs-validation custom-input" action="{{ route('accounts.update', $account->id) }}" method="POST">
          @csrf
          @method('PUT')
          <div class="col-12">
            <label class="form-label" for="clientName">اسم المستخدم</label>
            <input class="form-control" id="clientName" type="text" name="name" value="{{ old('name', $account->name) }}" placeholder="مثال: حسام عبدالله" required>
            @error('name')
            <div class="text-danger">
              {{ $message }}
            </div>
            @enderror
          </div>

          <div class="col-md-6">
            <label class="form-label">البريد الالكتروني</label>
            <input class="form-control" type="email" name="email" value="{{ old('email', $account->email) }}" placeholder="مثال: username@example.com" required>
            @error('email')
            <div class="text-danger">
              {{ $message }}
            </div>
            @enderror
          </div>

          <div class="col-md-6">
            <label class="form-label">رقم الهاتف</label>
            <input class="form-control" type="text" name="phone_number" value="{{ old('phone_number', $account->phone_number) }}" placeholder="أدخل الرقم مع كود الدولة (مثال: 249912345678)" required>
            @error('phone_number')
            <div class="text-danger">
              {{ $message }}
            </div>
            @enderror
          </div>


          <div class="col-md-6">
            <label class="form-label" for="contractNumber">عدد المناسبات المسموح بها</label>
            <input class="form-control" type="number" name="events_limit" value="{{ old('events_limit', $account->events_limit) }}" placeholder="مثال: 5" required min="1">
            @error('events_limit')
            <div class="text-danger">
              {{ $message }}
            </div>
            @enderror
          </div>

          <div class="col-md-6">
            <label class="form-label" for="contractNumber">عدد المنظمين المسموح به</label>
            <input class="form-control" type="number" name="staff_limit" value="{{ old('staff_limit', $account->staff_limit) }}" placeholder="مثال: 5" required min="1">
            @error('staff_limit')
            <div class="text-danger">
              {{ $message }}
            </div>
            @enderror
          </div>

          <div class="col-md-6">
            <label class="form-label" for="contractNumber">عدد الدعوات المسموح به</label>
            <input class="form-control" type="number" name="user_invitation_limit" value="{{ old('user_invitation_limit', $account->user_invitation_limit) }}" placeholder="مثال: 5" required min="1">
            @error('user_invitation_limit')
            <div class="text-danger">
              {{ $message }}
            </div>
            @enderror
          </div>



          <div class="col-12">
            <button class="btn btn-primary" type="submit">تعديل المستخدم</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <!-- End   Create Event Section -->

  @endsection