@extends('theme.partial.master')
@section('page-title', 'مناسبات ' . $account->name)
@section('content')




<div class="container-fluid">
  <div class="email-wrap bookmark-wrap">
    <div class="row">
      <div class="col-xl-12 col-md-12 box-col-80">
        <div class="email-right-aside bookmark-tabcontent">
          <div class="card email-body radius-left">
            <div class="ps-0">
              <div class="tab-content">
                <div class="tab-pane fade active show" id="pills-created" role="tabpanel" aria-labelledby="pills-created-tab">
                  <div class="card mb-0">
                    <div class="card-header d-flex pb-0">
                      <h4 class="mb-0">مناسبات {{ $account->name }}</h4>
                      <!-- <ul>
                        <li><a class="grid-bookmark-view" href="javascript:void(0)"><i data-feather="grid"></i></a></li>
                        <li><a class="list-layout-view" href="javascript:void(0)"><i data-feather="list"></i></a></li>
                      </ul> -->
                      <!-- ✅ شريط أزرار العرض (Grid / List) -->
                      <div class="d-flex justify-content-end gap-2 mb-3">
                        <button type="button" class="view-toggle-btn active" id="btnGrid" title="Grid">
                          <i class="fa fa-th"></i>
                        </button>
                        <button type="button" class="view-toggle-btn" id="btnList" title="List">
                          <i class="fa fa-bars"></i>
                        </button>
                      </div>

                    </div>
                    @if($events->count() > 0)
                    <style>
                      /* ✅ صورة ثابتة المقاس في كل الحالات */
                      .event-image-wrapper {
                        width: 100%;
                        aspect-ratio: 4 / 3;
                        /* غيّرها 1/1 لو تبغى مربع */
                        overflow: hidden;
                        background: #f1f1f1;
                        flex-shrink: 0;
                        border-radius: 12px;
                      }

                      .event-image-wrapper img {
                        width: 100%;
                        height: 100%;
                        object-fit: cover;
                        display: block;
                      }

                      /* ✅ Grid: 4 في الصف */
                      .grid-view .event-col {
                        margin-bottom: 16px;
                      }

                      /* ✅ List: نفس الصورة لكن بعرض ثابت (بدون ما يتغير طولها) */
                      .list-view .event-col {
                        width: 100%;
                        margin-bottom: 16px;
                      }

                      .list-view .event-card-inner {
                        display: flex;
                        gap: 16px;
                        align-items: flex-start;
                      }

                      /* عرض الصورة في وضع List (نفس النسبة + نفس القص) */
                      .list-view .event-image-wrapper {
                        width: 280px;
                        /* ثبّت العرض في list */
                        max-width: 280px;
                      }

                      /* محتوى الكرت */
                      .event-content {
                        flex: 1;
                        min-width: 0;
                      }

                      /* أزرار التبديل */
                      .view-toggle-btn {
                        border: 0;
                        background: transparent;
                        padding: 6px 8px;
                        border-radius: 10px;
                        cursor: pointer;
                      }

                      .view-toggle-btn.active {
                        background: rgba(0, 0, 0, 0.06);
                      }

                      /* (اختياري) توحيد ارتفاع الكرت في Grid */
                      .grid-view .bookmark-card {
                        height: 100%;
                      }
                    </style>
                    <div class="card-body pb-0">
                      <div class="details-bookmark text-center">
                        <div class="row grid-view" id="bookmarkData">

                          @foreach ($events as $event)
                          <div class="event-col col-xl-3 col-lg-3 col-md-6 col-sm-12">
                            <div class="card card-with-border bookmark-card o-hidden">
                              <div class="details-website">
                                <div class="event-card-inner">
                                  <div class="event-image-wrapper">
                                    <img class="img-fluid"
                                      src="{{ asset('storage/' . $event->event_image) }}"
                                      alt="{{ $event->event_name }}">
                                  </div>
                                  <div class="desciption-data event-content">
                                    <div class="title-bookmark">
                                      <h5 class="f-w-600">{{ $event->event_name }}</h5>

                                      <p class="text-muted mb-2">
                                        {{ Str::limit($event->description, 120) }}
                                      </p>

                                      <div class="hover-block">
                                        <ul>
                                          <li>
                                            <a href="{{ route('dashboard.editEvent', ['user' => $account->id, 'event' => $event->id]) }}">
                                              <i data-feather="edit-2"></i>
                                            </a>
                                          </li>
                                          <li><a href="#"><i data-feather="link"></i></a></li>
                                          <li><a href="#"><i data-feather="share-2"></i></a></li>
                                          <li><a href="#"><i data-feather="trash-2"></i></a></li>
                                          <li class="pull-right text-end"><a href="#"><i data-feather="tag"></i></a></li>
                                        </ul>
                                      </div>

                                    </div>
                                  </div>

                                </div><!-- /event-card-inner -->
                              </div>
                            </div>
                          </div>
                          @endforeach

                        </div>
                      </div>
                    </div>

                    <script>
                      const bookmarkData = document.getElementById('bookmarkData');
                      const btnGrid = document.getElementById('btnGrid');
                      const btnList = document.getElementById('btnList');

                      function setView(mode) {
                        if (mode === 'grid') {
                          bookmarkData.classList.remove('list-view');
                          bookmarkData.classList.add('grid-view');

                          // ✅ 4 في الصف
                          document.querySelectorAll('.event-col').forEach(col => {
                            col.classList.remove('col-12');
                            col.classList.add('col-xl-3', 'col-lg-3', 'col-md-6', 'col-sm-12');
                          });

                          btnGrid.classList.add('active');
                          btnList.classList.remove('active');
                        } else {
                          bookmarkData.classList.remove('grid-view');
                          bookmarkData.classList.add('list-view');

                          // ✅ list = صف كامل
                          document.querySelectorAll('.event-col').forEach(col => {
                            col.className = 'event-col col-12';
                          });

                          btnList.classList.add('active');
                          btnGrid.classList.remove('active');
                        }
                      }

                      btnGrid.addEventListener('click', () => setView('grid'));
                      btnList.addEventListener('click', () => setView('list'));
                    </script>

                    @else
                    <div class="justify-content-center d-flex flex-column align-items-center">
                      <h2 class="mt-3">لا توجد مناسبات بعد</h2>
                      <script src="https://unpkg.com/@lottiefiles/dotlottie-wc@0.8.11/dist/dotlottie-wc.js" type="module"></script>
                      <dotlottie-wc src="https://lottie.host/8b943b7c-9c0b-41ba-95bf-bd682f15d529/VkbOmAd2rv.lottie" style="width: 300px;height: 300px" autoplay loop></dotlottie-wc>
                    </div>
                    @endif
                    <!-- End Events -->
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection