@extends('theme.partial.master')
@section('page-title', 'مناسباتي')
@section('content')

<!-- start events page section -->

<div class="col-xl-12 proorder-xl-3 box-col-6 mt-4">
  <div class="card">
    <div class="card-header pb-0">
      <div class="header-top">
        <h1>مناسباتي</h1>
        <div class="dropdown icon-dropdown setting-menu">
          <button class="btn dropdown-toggle" id="userdropdown4" type="button" data-bs-toggle="dropdown" aria-expanded="false">
            <svg>
              <use href="{{ asset('assets/svg/icon-sprite.svg') }}#setting"> </use>
            </svg>
          </button>
          <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown4">
            <a class="dropdown-item" href="#">أسبوعي</a>
            <a class="dropdown-item" href="#">شهري</a>
            <a class="dropdown-item" href="#">سنوي</a>
          </div>
        </div>
      </div>
    </div>
    <div class="card-body">
      <div class="table-responsive custom-scrollbar">
        <table class="last-orders-table table" id="last-orders">
          <thead>
            <tr>
              <th>اسم المناسبة</th>
              <th>تاريخ المناسبة</th>
              <th>مكان المناسبة</th>
              <th>إجراء</th>
            </tr>
          </thead>
          <tbody>
            @if ($events->isEmpty())
            <tr>
              <td colspan="4" class="text-center">لا يوجد مناسبات</td>
            </tr>
            @else
            @foreach ($events as $event)
            <tr>
              <td>
                <a href="{{ route('theme.event', $event->event_slug) }}">{{ $event->event_name }}</a>
              </td>
              <td>{{ $event->event_date }}</td>
              <td>{{ $event->event_location }}</td>

              <td>
                <ul class="action" style="display: flex; gap: 10px;">
                  <li class="primary"><a href="#"><i class="icon-eye"></i></a></li>
                  <li class="edit"><a href="#"><i class="icon-pencil-alt"></i></a></li>
                  <li class="edit">
                    <a target="_blank" href="{{ route('theme.invitations', $event->event_slug) }}">
                      <i class="fa fa-qrcode"></i>
                      عرض الدعوات
                    </a>
                  </li>
                  <li class="delete"><a href="#"><i class="icon-trash"></i></a></li>
                </ul>
              </td>
            </tr>
            @endforeach
            @endif
          </tbody>
        </table>
        <a href="{{ route('theme.home') }}" target="_blank" rel="noopener noreferrer">
          <button class="btn btn-primary btn-lg text-light mt-4 p-2">
            أضف مناسبة جديدة
          </button>
        </a>
      </div>
    </div>
  </div>
</div>
<!-- end events page section -->

@endsection