@extends('theme.partial.master')
@section('page-title', 'لوحة التحكم')
@section('content')


<!-- Start body -->
@if (session('verified'))
<div class="alert alert-success">
  {{ session('verified') }}
</div>
@endif
<!-- Start Summary Section -->
@if (Auth::user()->role == 'admin')
<div class="col-xl-12 proorders-xl-2">
  <div class="card">
    <div class="card-header pb-0">
      <div class="header-top">
        <h4>الملخص</h4>
        <div class="dropdown icon-dropdown setting-menu">
          <button class="btn dropdown-toggle" id="userdropdown32" type="button" data-bs-toggle="dropdown" aria-expanded="false">
            <svg>
              <use href="{{ asset('assets/svg/icon-sprite.svg') }}#setting"> </use>
            </svg>
          </button>
          <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown32">
            <a class="dropdown-item" href="#">اسبوعي</a>
            <a class="dropdown-item" href="#">شهري</a>
            <a class="dropdown-item" href="#">سنوي</a>
          </div>
        </div>
      </div>
    </div>
    <div class="card-body pt-0 summary-card"><span class="f-w-700 f-14">منذ البداية إلى {{ date('Y-m-d') }}</span>
      <div class="summary-progressbar">
        <ul>
          <li>
            <div>
              <h4>{{ $events->count() }} \ {{ Auth::user()->events_limit }}</h4><span>عدد المناسبات</span>
            </div>
            <div class="progress-showcase">
              <div class="progress sm-progress-bar progress-border-primary">
                <div class="progress-bar bg-primary" role="progressbar" style="width: {{ Auth::user()->events_limit > 0 ? min(100, ($events->count() / Auth::user()->events_limit) * 100) : 0 }}%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"> </div>
              </div>
            </div>
          </li>
          <li>
            <div>
              <h4>{{ Auth::user()->user_invitation_limit }}</h4><span> الدعوات المسموحة</span>
            </div>
            <div>
              <div class="progress sm-progress-bar progress-border-secondary">
                <div class="progress-bar bg-secondary" role="progressbar" style="width: {{ Auth::user()->user_invitation_limit > 0 ? min(100, ($events->sum('invitations_count') / 1) * 100) : 0 }}%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"> </div>
              </div>
            </div>
          </li>
          <li>
            <div>
              <h4>{{ $events->sum('invitations_count') }} \ {{ Auth::user()->user_invitation_limit }}</h4><span>عدد الدعوات المنشئة </span>
            </div>
            <div>
              <div class="progress-showcase">
                <div class="progress sm-progress-bar progress-border-secondary">
                  <div class="progress-bar"
                    style="width: {{ Auth::user()->user_invitation_limit > 0 ? min(100, ($events->sum('invitations_count') / Auth::user()->user_invitation_limit) * 100) : 0}}%">
                  </div>
                </div>
              </div>
            </div>
          </li>
          <li>
            <div>
              <h4>{{ Auth::user()->user_invitation_limit - $events->sum('invitations_count') }}</h4><span>الدعوات المتبقية</span>
            </div>
            @php
            $total = Auth::user()->user_invitation_limit;
            $used = $events->sum('invitations_count');
            $remaining = max(0, $total - $used);

            $percent = $total > 0 ? ($remaining / $total) * 100 : 0;
            @endphp

            <div>
              <div class="progress sm-progress-bar progress-border-secondary">
                <div class="progress-bar bg-secondary" role="progressbar" style="width: {{ min(100, $percent) }}%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"> </div>
              </div>
            </div>
          </li>
        </ul>
      </div>
    </div>
  </div>
</div>
<!-- End Summary Section -->

<!-- Start Create Event Section -->
<h3>اضافة مناسبة</h3>
<div class="col-xl-12 mt-4">
  @if(session()->has('addEventSuccess'))
  <script>
    Swal.fire({
      icon: 'success',
      title: 'تم بنجاح',
      text: "{{ session('addEventSuccess') }}",
      confirmButtonText: 'حسناً'
    });
  </script>
  @endif

  @if(session()->has('addEventError'))
  <script>
    Swal.fire({
      icon: 'error',
      title: 'خطأ',
      text: "{{ session('addEventError') }}",
      confirmButtonText: 'إغلاق'
    });
  </script>
  @endif

  @if(session()->has('addEventWarning'))
  <script>
    Swal.fire({
      icon: 'warning',
      title: 'تنبيه',
      text: "{{ session('addEventWarning') }}",
      confirmButtonText: 'موافق'
    });
  </script>
  @endif


  <div class="card height-equal">
    <div class="card-header pb-0">
      <h4>نموذج إدخال مناسبة</h4>
      <p class="f-m-light mt-1">يرجى تعبئة كافة الحقول بشكل صحيح قبل الإرسال.</p>
    </div>
    <div class="card-body">
      <form class="row g-3 needs-validation custom-input" novalidate="" action=" {{ route('events.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="col-12">
          <label class="form-label" for="clientName">اسم المناسبة</label>
          <input class="form-control" id="clientName" type="text" name="event_name" value="{{ old('event_name') }}" placeholder="مثال: حفل زواج مزن وعبدالعزيز" required>
          @error('event_name')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-6">
          <label class="form-label" for="sourceTransfer">تاريخ المناسبة</label>
          <input class="form-control" id="sourceTransfer" type="date" name="event_date" value="{{ old('event_date') }}" placeholder="مثال: 2026-01-18" min="{{ date('Y-m-d') }}" required>
          @error('event_date')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-6">
          <label class="form-label" for="sourceTransfer">زمن المناسبة</label>
          <input class="form-control" id="sourceTransfer" type="time" name="event_time" value="{{ old('event_time') }}" placeholder="مثال: 2026-01-18" min="{{ date('H:i') }}" required>
          @error('event_time')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-md-6">
          <label class="form-label" for="contractNumber">مكان المناسبة</label>
          <input class="form-control" id="contractNumber" type="text" name="event_location" value="{{ old('event_location') }}" placeholder="مثال: قاعة اللؤلؤة" required>
          @error('event_location')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-md-6">
          <label class="form-label" for="contractNumber">رابط الموقع</label>
          <input class="form-control" id="contractNumber" type="text" name="location_url" value="{{ old('location_url') }}" placeholder="مثال: https://maps.app.goo.gl/" required>
          @error('location_url')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-md-12">
          <label class="form-label" for="signDate">صورة الدعوة</label>
          <input class="form-control" id="signDate" type="file" name="event_image" value="{{ old('event_image') }}" required>
          @error('event_image')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <!-- <div class="col-12">
          <div class="form-check">
            <input class="form-check-input" id="invalidCheck" type="checkbox" value="" required>
            <label class="form-check-label" for="invalidCheck">أوافق على الشروط والأحكام</label>
            @error('invalidCheck')
            <div class="text-danger">
              {{ $message }}
            </div>
            @enderror
          </div>
        </div>
        -->

        <div class="col-12">
          <button class="btn btn-primary" type="submit">إضافة المناسبة</button>
        </div>
      </form>
    </div>
  </div>
</div>
<!-- End   Create Event Section -->
@else
@include('theme.scanner.scan')
@endif
<!-- End body -->

@endsection