@extends('theme.partial.master')
@section('page-title', 'المنظمين')
@section('content')


<div class="col-xl-12 proorder-xl-3 box-col-6 mt-4">
  <div class="card">
    <div class="card-header pb-0">
      <div class="header-top">
        <h1>
          منظمي المناسبة
        </h1>
      </div>
    </div>
    <div class="card-body">
      <div class="table-responsive custom-scrollbar">
        <table class="last-orders-table table" id="last-orders">
          <thead>
            <tr>
              <th>#</th>
              <th>الاسم</th>
              <th>البريد الالكتروني</th>
              <th>إجراءات</th>
            </tr>
          </thead>
          <tbody>
            @if ($teamMembers->isEmpty())
            <tr>
              <td colspan="5" class="text-center">لا يوجد دعوات</td>
            </tr>
            @else
            @foreach ($teamMembers as $teamMember)
            <tr>
              <td>{{ $teamMembers->firstItem() + $loop->iteration - 1 }}</td>
              <td>{{ $teamMember->name }}</td>
              <td>{{ $teamMember->email }}</td>


              <td>
                <ul class="action gap-3">
                  <li class="primary">
                    <a target="_blank" href="#">
                      <i class="fa fa-edit"></i>
                    </a>
                  </li>
                  <li class="edit">
                    <a href="#">
                      <i class="fa fa-trash"></i>
                    </a>
                  </li>
                  <!-- <li class="delete"><a href="#"><i class="icon-trash"></i></a></li> -->
                </ul>
              </td>
            </tr>
            @endforeach
            @endif
          </tbody>
        </table>

        <div class="mt-4 me-4">
          <a href="{{ route('scan.create') }}" class="btn btn-primary">إضافة منظم جديد</a>
        </div>

        @if ($teamMembers->hasPages())
        <div class="mt-4 me-4">
          {{ $teamMembers->links('pagination::bootstrap-5') }}
        </div>
        @endif

      </div>
    </div>
  </div>
</div>


@endsection