<?php $__env->startSection('page-title', 'مناسباتي'); ?>
<?php $__env->startSection('content'); ?>

<!-- start events page section -->

<div class="col-xl-12 proorder-xl-3 box-col-6 mt-4">
  <div class="card">
    <div class="card-header pb-0">
      <div class="header-top">
        <h1>مناسباتي</h1>
        <div class="dropdown icon-dropdown setting-menu">
          <button class="btn dropdown-toggle" id="userdropdown4" type="button" data-bs-toggle="dropdown" aria-expanded="false">
            <svg>
              <use href="<?php echo e(asset('assets/svg/icon-sprite.svg')); ?>#setting"> </use>
            </svg>
          </button>
          <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown4">
            <a class="dropdown-item" href="#">أسبوعي</a>
            <a class="dropdown-item" href="#">شهري</a>
            <a class="dropdown-item" href="#">سنوي</a>
          </div>
        </div>
      </div>
    </div>
    <div class="card-body">
      <div class="table-responsive custom-scrollbar">
        <table class="last-orders-table table" id="last-orders">
          <thead>
            <tr>
              <th>اسم المناسبة</th>
              <th>تاريخ المناسبة</th>
              <th>مكان المناسبة</th>
              <th>إجراء</th>
            </tr>
          </thead>
          <tbody>
            <?php if($events->isEmpty()): ?>
            <tr>
              <td colspan="4" class="text-center">لا يوجد مناسبات</td>
            </tr>
            <?php else: ?>
            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td>
                <a href="<?php echo e(route('theme.event', $event->event_slug)); ?>"><?php echo e($event->event_name); ?></a>
              </td>
              <td><?php echo e($event->event_date); ?></td>
              <td><?php echo e($event->event_location); ?></td>

              <td>
                <ul class="action" style="display: flex; gap: 10px;">
                  <li class="primary"><a href="#"><i class="icon-eye"></i></a></li>
                  <li class="edit"><a href="#"><i class="icon-pencil-alt"></i></a></li>
                  <li class="edit">
                    <a target="_blank" href="<?php echo e(route('theme.invitations', $event->event_slug)); ?>">
                      <i class="fa fa-qrcode"></i>
                      عرض الدعوات
                    </a>
                  </li>
                  <li class="delete"><a href="#"><i class="icon-trash"></i></a></li>
                </ul>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          </tbody>
        </table>
        <a href="<?php echo e(route('theme.home')); ?>" target="_blank" rel="noopener noreferrer">
          <button class="btn btn-primary btn-lg text-light mt-4 p-2">
            أضف مناسبة جديدة
          </button>
        </a>
      </div>
    </div>
  </div>
</div>
<!-- end events page section -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.partial.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\inviter\resources\views/theme/events.blade.php ENDPATH**/ ?>